{========================================================================}
{=                (c) 1995-99 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 22.03.99 - 15:52:02 $                                        =}
{========================================================================}
unit CDDB;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ShellApi, Buttons, MMString;

type
  TCDDBDlg = class(TForm)
    GroupBox1: TGroupBox;
    editServer: TEdit;
    editLocation: TEdit;
    btnGetSites: TBitBtn;
    GroupBox2: TGroupBox;
    editEmail: TEdit;
    Label1: TLabel;
    GroupBox3: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    lblAddress: TLabel;
    Button1: TButton;
    Button2: TButton;
    procedure lblAddressClick(Sender: TObject);
    procedure btnGetSitesClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
  private
    OldEmail: string;
  public
  end;

var
  CDDBDlg: TCDDBDlg;

implementation

uses CDMain, CDDBSel, CDDBPro;

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TCDDBDlg.lblAddressClick(Sender: TObject);
begin
   ShellExecute(0, nil, PChar(lblAddress.Caption), nil, nil, SW_SHOWDEFAULT);
end;

{------------------------------------------------------------------------------}
procedure TCDDBDlg.btnGetSitesClick(Sender: TObject);
var
   i: integer;
   ActiveWindow: HWnd;
   WindowList: Pointer;
begin
   if (editEmail.Text = '') then
   begin
      MessageDlg('Invalid e-mail address', mtInformation, [mbOK], 0);
      exit;
   end;

   with CDMainForm.CDDB do
   begin
      Email := editEmail.Text;

      if (Sites.Count = 0) then
      begin
         CDDBProgress := TCDDBProgress.Create(Self);
         with CDDBProgress do
         try
            ActiveWindow := GetActiveWindow;
            WindowList := DisableTaskWindows(0);
            try
               Show;
               Update;
               ReadCDDBSites;
            finally
               EnableTaskWindows(WindowList);
               SetActiveWindow(ActiveWindow);
            end;
         finally
            Free;
         end;
      end;

      if (Sites.Count > 0) then
      begin
         with TCDDBSelectDlg.Create(Self) do
         try
            Header.Sections[0] := 'Internet Address';
            Header.Sections[1] := 'Located at';
            Header.SectionWidth[0] := Width div 2;
            Header.SectionWidth[1] := Width div 2;
            Caption := 'Available CDDB sites';
            Label1.Caption := 'Select a site close to you.';
            for i := 0 to Sites.Count-1 do
            begin
               ListBox.Items.Add(Sites[i].Address+#9+Sites[i].Location);
            end;
            if (ShowModal = mrOK) and (SelectedItem >= 0) then
            begin
               editServer.Text  := Sites[SelectedItem].Address;
               editLocation.Text:= Sites[SelectedItem].Location;
            end;
         finally
            Free;
         end;
      end;
   end;
end;

{------------------------------------------------------------------------------}
procedure TCDDBDlg.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
   if (ModalResult = mrOK) then
   begin
      if (editEmail.Text <> '') then
          CanClose := True
      else
      begin
         MessageDlg('Invalid e-mail address', mtInformation, [mbOK], 0);
         CanClose := False;
      end;
   end
   else CanClose := True;
end;

{------------------------------------------------------------------------------}
procedure TCDDBDlg.FormShow(Sender: TObject);
begin
   OldEmail := CDMainForm.CDDB.Email;
end;

{------------------------------------------------------------------------------}
procedure TCDDBDlg.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if (ModalResult <> mrOK) then
   with CDMainForm.CDDB do
   begin
      CDMainForm.CDDB.Email := OldEmail;
   end;
end;

end.
